<?php
// Koneksi ke database
$conn = new mysqli('localhost', 'root', '', 'file_management');


// Cek koneksi
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Query untuk mengambil data file
$result = $conn->query("SELECT filename, filepath FROM files");

// Menampilkan file
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Download File</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container">
        <h2 class="my-4">Daftar File</h2>
        <div class="row">
            <?php
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo '<div class="col-md-4">';
                    echo '<div class="card mb-4">';

                    // Menampilkan gambar thumbnail jika file adalah gambar
                    $file_ext = pathinfo($row['filename'], PATHINFO_EXTENSION);
                    if (in_array($file_ext, ['jpg', 'jpeg', 'png', 'gif'])) {
                        echo '<img src="' . $row['filepath'] . '" class="card-img-top" alt="' . htmlspecialchars($row['filename']) . '">';
                    } elseif (in_array($file_ext, ['mp4', 'avi', 'mov'])) {
                        // Menampilkan video
                        echo '<video controls class="card-img-top" style="width: 100%;">';
                        echo '<source src="' . $row['filepath'] . '" type="video/' . $file_ext . '">';
                        echo 'Your browser does not support the video tag.';
                        echo '</video>';
                    } else {
                        echo '<img src="images/file_placeholder.png" class="card-img-top" alt="File Placeholder">'; // Ganti dengan gambar placeholder
                    }

                    echo '<div class="card-body">';
                    echo '<h5 class="card-title">' . htmlspecialchars($row['filename']) . '</h5>';
                    echo '<a href="' . $row['filepath'] . '" class="btn btn-primary" download>Download</a>';
                    echo '</div>';
                    echo '</div>';
                    echo '</div>';
                }
            } else {
                echo "Tidak ada file yang ditemukan.";
            }
            ?>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>

<?php
$conn->close();
?>
